/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.EdidEditor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

class CommandAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Command command;

    CommandAction(String string, Command command) {
        super(string);
        this.command = command;
    }

    CommandAction(String string, Command command, KeyStroke keyStroke, int n) {
        this(string, command);
        if (keyStroke != null) {
            this.putValue("AcceleratorKey", keyStroke);
        }
        if (n != 0) {
            this.putValue("MnemonicKey", n);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = null;
        switch (this.command) {
            case LOAD_FROM_882: {
                EdidEditor.theApp.OpenFileFrom882();
                break;
            }
            case LOAD_FROM_DEV_ON_882: {
                string = actionEvent.getActionCommand();
                char c = string.charAt(string.length() - 1);
                EdidEditor.theApp.OpenFileFromDevOn882(c - 48);
                break;
            }
            case LOAD_FROM_PC: {
                EdidEditor.theApp.OpenFileFromPC();
                break;
            }
            case SAVE_TO_882: {
                EdidEditor.theApp.SaveEdidTo882();
                break;
            }
            case SAVE_TO_PC: {
                EdidEditor.theApp.SaveEdidToPC();
                break;
            }
            case SAVE_TO_DEV_ON_882: {
                string = actionEvent.getActionCommand();
                char c = string.charAt(string.length() - 1);
                EdidEditor.theApp.SaveToDevOn882(c - 48);
                break;
            }
            case USE_ON_PORT: {
                string = actionEvent.getActionCommand();
                char c = string.charAt(string.length() - 1);
                EdidEditor.theApp.UseEdidOn882(c - 48);
                break;
            }
            case QUIT: {
                EdidEditor.theApp.ExitEdidApp();
                break;
            }
            case NEW_DTD_TIME_DESC: {
                EdidEditor.theApp.NewTimDescDTDPanel(actionEvent.getActionCommand(), this.command);
                break;
            }
            case NEW_DTD_TIM_PREDEF1: 
            case NEW_DTD_TIM_PREDEF2: 
            case NEW_DTD_TIM_PREDEF3: 
            case NEW_DTD_TIM_PREDEF4: {
                EdidEditor.theApp.AddNewTimDescDTD(actionEvent.getActionCommand(), this.command);
                break;
            }
            case NEW_DTD_MON_SER_DESC: 
            case NEW_DTD_ASCII_DESC: 
            case NEW_DTD_MON_RANGE_DESC: 
            case NEW_DTD_MON_NAME_DESC: 
            case NEW_DTD_STI_DESC: 
            case NEW_DTD_MANF_DESC: {
                EdidEditor.theApp.NewDTDPanel(actionEvent.getActionCommand(), this.command);
                break;
            }
            case NEW_CEA_BLOCK: {
                EdidEditor.theApp.CreateNewCEABlock();
                break;
            }
            case NEW_CEA_VIDEO_EXT: 
            case NEW_CEA_AUDIO_EXT: 
            case NEW_CEA_SPEAK_EXT: 
            case NEW_CEA_VENDOR_EXT: 
            case NEW_CEA_COLORIMETRY_EXT: 
            case NEW_CEA_VIDEO_CAPABILITY_EXT: {
                EdidEditor.theApp.NewCEAExtPanel(actionEvent.getActionCommand(), this.command);
                break;
            }
            case GEN_EDID_REPORT: {
                string = actionEvent.getActionCommand();
                char c = string.charAt(string.length() - 1);
                EdidEditor.theApp.GenerateEDIDReport();
                break;
            }
            case RUN_COMP_TEST: {
                string = actionEvent.getActionCommand();
                char c = string.charAt(string.length() - 1);
                EdidEditor.theApp.GenerateComplianceTest();
                break;
            }
            case DELETE_SEL_ITEM: {
                EdidEditor.theApp.DeleteSelectedItem();
                break;
            }
            case CONFIG_882_ADDR: {
                EdidEditor.theApp.Config882Addr();
                break;
            }
            case MOVE_DOWN_BLOCK: {
                EdidEditor.theApp.MoveBlockDown();
                break;
            }
            case MOVE_UP_BLOCK: {
                EdidEditor.theApp.MoveBlockUp();
                break;
            }
            case SAVE_EDID_REPORT: {
                EdidEditor.theApp.SaveEdidReport(false);
                break;
            }
            case SAVE_EDID_COMP_RPT: {
                EdidEditor.theApp.SaveEdidReport(true);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        LOAD_FROM_882,
        LOAD_FROM_DEV_ON_882,
        LOAD_FROM_PC,
        SAVE_TO_882,
        SAVE_TO_PC,
        SAVE_TO_DEV_ON_882,
        USE_ON_PORT,
        QUIT,
        NEW_DTD_TIME_DESC,
        NEW_DTD_TIM_PREDEF1,
        NEW_DTD_TIM_PREDEF2,
        NEW_DTD_TIM_PREDEF3,
        NEW_DTD_TIM_PREDEF4,
        NEW_DTD_MON_SER_DESC,
        NEW_DTD_ASCII_DESC,
        NEW_DTD_MON_RANGE_DESC,
        NEW_DTD_MON_NAME_DESC,
        NEW_DTD_STI_DESC,
        NEW_DTD_MANF_DESC,
        NEW_CEA_BLOCK,
        NEW_CEA_VIDEO_EXT,
        NEW_CEA_AUDIO_EXT,
        NEW_CEA_SPEAK_EXT,
        NEW_CEA_VENDOR_EXT,
        NEW_CEA_COLORIMETRY_EXT,
        NEW_CEA_VIDEO_CAPABILITY_EXT,
        CONFIG_882_ADDR,
        GEN_EDID_REPORT,
        RUN_COMP_TEST,
        DELETE_SEL_ITEM,
        MOVE_DOWN_BLOCK,
        MOVE_UP_BLOCK,
        SAVE_EDID_REPORT,
        SAVE_EDID_COMP_RPT;

    }
}

